<?php

namespace Kozhilya\MybbConnection\Exceptions;

use Exception;
use Kozhilya\MybbConnection\MybbResponse;

class MybbCurlException extends Exception
{
    public function __construct(
        private readonly MybbResponse $response,
        private readonly string $curlMessage
    )
    {
        parent::__construct(sprintf("Ошибка Curl при попытке выполнить запрос к странице \"%s\": \"%s\".",
            $this->response->getUrl(),
            $curlMessage
        ));
    }

    /**
     * @return MybbResponse
     */
    public function getResponse(): MybbResponse
    {
        return $this->response;
    }

    /**
     * @return string
     */
    public function getCurlMessage(): string
    {
        return $this->curlMessage;
    }
}