<?php

namespace Kozhilya\MybbConnection\Exceptions;

use Exception;

class MybbFormProcessorMissingOptionsException extends Exception
{
    public function __construct(
        private readonly array $missingKeys,
        private readonly array $requiredKeys,
        private readonly string $className
    )
    {
        parent::__construct(sprintf("Невозможно проинициализировать обработчик формы\"%s\", так как не хватает настроек [%s].",
            $this->className,
            '"' . implode('", "', $this->missingKeys) . '"',
        ));
    }

    /**
     * @return array
     */
    public function getMissingKeys(): array
    {
        return $this->missingKeys;
    }

    /**
     * @return array
     */
    public function getRequiredKeys(): array
    {
        return $this->requiredKeys;
    }

    /**
     * @return string
     */
    public function getClassName(): string
    {
        return $this->className;
    }

}