<?php

namespace Kozhilya\MybbConnection\FormProcessor;

use Kozhilya\MybbConnection\Exceptions\FormKeyParserException;
use Kozhilya\MybbConnection\Exceptions\MybbCurlException;
use Kozhilya\MybbConnection\Exceptions\MybbFormProcessorMissingOptionsException;

/**
 * Обработчик формы отправки сообщений
 */
class NewPostProcessor extends PostProcessor
{
    /**
     * ID тесы, в которой необходимо создание сообщения
     * @var int
     */
    public int $topic_id;

    /**
     * Инициализация обработчика дополнительными параметрами
     *
     * @param array $options Дополнительные параметры
     *
     * @throws MybbFormProcessorMissingOptionsException
     * @throws FormKeyParserException
     * @throws MybbCurlException
     */
    public function init(array $options): void
    {
        $this->assertOptions($options, ['topic_id']);

        $this->topic_id = $options['topic_ic'];

        $this->getFormKeys(sprintf('/post.php?tid=%s', $this->topic_id));
    }
}