<?php

namespace Kozhilya\MybbConnection;

/**
 * Пользователь форума Mybb.ru
 */
abstract class MybbUser
{
    /**
     * Логин пользователя Mybb.ru
     * @var string
     */
    protected string $login;

    /**
     * Пароль пользователя Mybb.ru
     * @var string
     */
    protected string $password;

    /**
     * @param string $login Логин
     * @param string $password Пароль
     */
    public function __construct(string $login, string $password)
    {
        $this->login = $login;
        $this->password = $password;
    }

    /**
     * Логин пользователя Mybb.ru
     * @return string
     */
    public function getLogin(): string
    {
        return $this->login;
    }

    /**
     * Установка логина пользователя Mybb.ru
     * @param string $login
     * @return MybbUser
     */
    public function setLogin(string $login): MybbUser
    {
        $this->login = $login;

        return $this;
    }

    /**
     * Пароль пользователя Mybb.ru
     * @return string
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    /**
     * Установка пароля пользователя Mybb.ru
     * @param string $password
     * @return MybbUser
     */
    public function setPassword(string $password): MybbUser
    {
        $this->password = $password;

        return $this;
    }

    /**
     * Получение списка Cookies
     * @return array|null
     */
    abstract function getCookies(): ?array;

    /**
     * Установка Cookies
     * @param array|null $cookies
     */
    abstract function setCookies(?array $cookies): void;

    /**
     * Добавление новых Cookies
     * @param array|null $cookies
     */
    function addCookies(?array $cookies): void
    {
        $cookies = ($cookies ?? []) + ($this->getCookies() ?? []);

        $this->setCookies($cookies);
    }

    /**
     * Получение строкового представления Cookies
     * @return string
     */
    function getCookiesString(): string
    {
        $cookies = $cookies ?? [];
        $result = [];
        foreach ($cookies as $key => $value) {
            $result[] = urlencode($key).'='.urlencode($value);
        }

        return implode(';', $result);
    }
}