<?php

namespace Kozhilya\MybbConnection\Delayers;

/**
 * Абстрактный класс для обеспечения запросов к Mybb.ru в очереди
 */
abstract class AbstractDelayer
{
    /**
     * Задержка перед отправкой нового сообщений
     */
    protected float $min_access_delay = 1.0;

    /**
     * Ожидание в очереди запросов к серверу Mybb
     *
     * @param string $id id запроса
     * @return void Завершение ожидания
     */
    public abstract function waitQueue(string $id): void;

    /**
     * Информация о последнем запросе к серверу Mybb
     *
     * @return float
     */
    public abstract function lastAccess(): float;

    /**
     * Обновление информации о времени последнего доступа
     */
    public abstract function updateAccess(): void;

    /**
     * Гарантированное ожидание доступа
     */
    public function waitAccess(): void
    {
        $target = $this->lastAccess() + $this->min_access_delay;

        if (microtime(true) < $target) {
            time_sleep_until($target);
        }
    }

    /**
     * Задержка перед отправкой нового сообщений
     *
     * @return float
     */
    public function getMinAccessDelay(): float
    {
        return $this->min_access_delay;
    }

    /**
     * Задержка перед отправкой нового сообщений
     *
     * @param float $min_access_delay
     * @return AbstractDelayer
     */
    public function setMinAccessDelay(float $min_access_delay): AbstractDelayer
    {
        $this->min_access_delay = $min_access_delay;

        return $this;
    }

}