<?php

namespace Kozhilya\MybbConnection\FormProcessor;

use Kozhilya\MybbConnection\Exceptions\FormKeyParserException;
use Kozhilya\MybbConnection\Exceptions\MybbCurlException;
use Kozhilya\MybbConnection\Exceptions\MybbFormProcessorMissingOptionsException;

class EditPostProcess extends PostProcessor
{
    public int $post_id;

    /**
     * Инициализация обработчика дополнительными параметрами
     *
     * @param array $options Дополнительные параметры
     *
     * @throws MybbFormProcessorMissingOptionsException
     * @throws FormKeyParserException
     * @throws MybbCurlException
     */
    public function init(array $options): void
    {
        $this->assertOptions($options, ['post_id']);

        $this->post_id = $options['post_id'];

        $this->getFormKeys(sprintf('/edit.php?tid=%s', $this->post_id));
    }
}