<?php

namespace Kozhilya\MybbConnection\FormProcessor;

use DOMElement;
use Kozhilya\MybbConnection\Exceptions\FormKeyParserException;
use Symfony\Component\DomCrawler\Crawler;

class FormKeyParser
{
    /**
     * @var string[]
     */
    public array $log = [];

    private string $html;

    private string $methodName;

    private Crawler $crawler;

    private array $vars = [];

    private function log($template, ...$args): void
    {
        $this->log[] = sprintf($template, ...$args);

//        printf($template, ...$args);
//        print((php_sapi_name() === 'cli') ? PHP_EOL : '<br />');
    }

    public function __construct(string $html)
    {
        $this->html = $html;
    }

    /**
     * @throws FormKeyParserException
     */
    public function process(): array
    {
        if (!preg_match(
            '#<script.*?>\\s+<!--\\s+(function process_form[\\s\\S]*?)\\s*-->\\s*</script>#m',
            $this->html,
            $match
        )) {
            throw FormKeyParserException::create('Критическая ошибка генерации ключа отправки: robochecker не найден.', $this);
        }

        $this->log('Страница загружена');

        $full_script = $match[1];
        $this->log('Полученный скрипт: <xmp>%s</xmp>', $full_script);
        $js = explode("\n", $full_script);

        if (!preg_match("#^function ([a-zA-Z]*)#", $js[count($js) - 1], $q)) {
            throw FormKeyParserException::create('Критическая ошибка генерации ключа отправки: идентифицирующая функция не найдена.', $this);
        }

        $this->methodName = $q[1];
        $this->log('getElementById: %s', $this->methodName);

        preg_match("#(document\.getElementById\('formkey'\).*?;)\r?\n#m", $full_script, $match);
        $script = $match[1];
        $commands = array_filter(explode(";", trim($script)));

        $defaults = '<form><div id="formkey"></div><div id="formetc" style="display:none"></div><button>validate</button></form>';

        $this->crawler = new Crawler($defaults, 'http://example.test/');

        $c = count($commands);

        for ($i = 0; $i < $c; $i++) {
            $this->log('===== Command %d =====', $i);

            $this->processCommand($commands[$i]);
        }

        $form = $this->crawler->selectButton('validate')->form();
        return $form->getPhpValues();

    }

    private function getElementById(string $id): Crawler
    {
        return $this->crawler->filter(sprintf('#%s', $id));
    }

    /**
     * @throws FormKeyParserException
     */
    private function setElementById(string $id, string $value): void
    {
        $crawler = $this->crawler->filter(sprintf('#%s', $id));
        $element =  $crawler->getNode(0);

        if(!$element instanceof DOMElement)
            throw FormKeyParserException::create('Ошибка DOMElement.', $this);

        // Fix <input>
        /** @noinspection HtmlUnknownAttribute */
        $value = preg_replace('#<input\s(.*?)>#', '<input $1 />', $value);

        $fragment = $element->ownerDocument->createDocumentFragment();
        $fragment->appendXML($value);

        while ($element->hasChildNodes())
            $element->removeChild($element->firstChild);
        $element->appendChild($fragment);
    }

    /**
     * @throws FormKeyParserException
     */
    private function processCommand(string $cmd): void
    {
        $this->log('JS: <kbd>%s</kbd>', $cmd);

        if (preg_match("#^document\.getElementById\('(\w+)'\)\.innerHTML=(unescape\(.*?\))$#", $cmd, $q)) {

            $this->log('Обновление HTML в #%s', $q[1]);

            $value = $this->parse($q[2]);
            $this->log('Добавляется HTML: <kbd>%s</kbd>', htmlentities($value));

            $this->setElementById($q[1], $value);
        }
        elseif (preg_match(sprintf('/([\w]*)=%s\(\'([\w]*)\'\)/', $this->methodName), $cmd, $q)) {
            $this->log('Читаем переменную <kbd>%s</kbd>', $q[1]);
            $this->vars[$q[1]] = $this->getElementByID($q[2])->html();
            $this->log('Установлено значение <kbd>%s</kbd>', $this->vars[$q[1]]);
        }
        elseif (preg_match("#([\w]*)=([\w]*|'')\+([\w]*)\.innerHTML#", $cmd, $q)) {
            $this->log('Генерируем код в переменную <kbd>%s</kbd>', $q[1]);

            $part1 = ($q[2] == "''") ? '' : $this->vars[$q[2]];
            $part2 = $this->vars[$q[3]];

            $this->vars[$q[1]] = $part1 . $part2;

            $this->log('Установлено значение <kbd>"%s"</kbd> + <kbd>"%s"</kbd> = <kbd>"%s"</kbd>',
                $part1,
                $part2,
                $this->vars[$q[1]]
            );
        }
        elseif (preg_match("#^document\.getElementById\('(\w+)'\)\.getElementsByTagName.*=(unescape\(.*?\))$#", $cmd, $q))
        {
            $this->log('Обновление значения поля ввода в #%s', $q[1]);

            $value = $this->parse($q[2]);
            $this->log('Устанавливается значение: <kbd>%s</kbd>', htmlentities($value));

            $first = $this->getElementById($q[1])->children()->getNode(0);
            if(!$first instanceof DOMElement)
                throw FormKeyParserException::create('Ошибка DOMElement.', $this);

            $first->setAttribute('value', $value);
        }
        else {
            $this->log("WTF: <kbd>%s</kbd>", $cmd);
            throw FormKeyParserException::create('Неизвестная JS команда.', $this);
        }
    }

    private function parse(string $js): string
    {
        preg_match("#unescape\(([\w']*)\.replace\(/(\w)#", $js, $q);
        $d = $q[1];

        if (str_starts_with($d, "'")) {
            $d = str_replace("'", '', $d);
            return static::unescape($d);
        }
        else {
            return static::unescape($this->vars[$d]);
        }
    }

    private static function unescape($str): string
    {
        $ch = $str[0];
        return urldecode(preg_replace(sprintf('/%s([\w]{2})/', $ch), "%$1", $str));
    }
}