<?php

namespace Kozhilya\MybbConnection\FormProcessor;

class ProfileProcessor extends MybbFormProcessor
{
    /**
     * ID изменяемого профиля
     * @var int
     */
    public int $profile_id;

    /**
     * Производимое действие
     * @var string
     */
    public string $action;

    /**
     * Поле GET-запроса, соответсвующее производимому действию
     * @var string
     */
    public string $action_field_name;

    public function init(array $options): void
    {
        $this->assertOptions($options, ['profile_id', 'action']);

        $this->profile_id = $options['profile_id'];
        $this->action = $options['action'];

        $this->action_field_name = 'section';

        if (($this->action == 'change_pass')) {
            $this->action_field_name = 'action';
            $this->button_selector = '[type="submit"]';
        }

        $this->getFormKeys(printf('/profile.php?%s=%s&id=%d',
            $this->action_field_name,
            $this->action,
            $this->profile_id
        ));
    }
}