<?php

namespace Kozhilya\MybbConnection\Exceptions;

use Exception;

class MybbApiException extends Exception
{
    public function __construct(
        private readonly string $mybbMessage,
        private readonly string $method,
        private readonly ?array $params = null)
    {
        parent::__construct(sprintf("Ошибка при попытке выполнить API-метод \"%s\": \"%s\". Использованные аргументы: %s",
            $method,
            $mybbMessage,
            var_export($params, true)
        ));
    }

    /**
     * @return string
     */
    public function getMybbMessage(): string
    {
        return $this->mybbMessage;
    }

    /**
     * @return string
     */
    public function getMethod(): string
    {
        return $this->method;
    }

    /**
     * @return array|null
     */
    public function getParams(): ?array
    {
        return $this->params;
    }
}