<?php

namespace Kozhilya\MybbConnection\FormProcessor;

use Kozhilya\MybbConnection\Exceptions\MybbCurlException;
use Kozhilya\MybbConnection\MybbResponse;
use Kozhilya\MybbConnection\Util\MybbEncoder;

/**
 * Общий класс-обработчик форм отправки сообщений
 */
abstract class PostProcessor extends MybbFormProcessor
{
    /**
     * Имя поля ввода сообщения
     */
    public const MESSAGE_FIELD = 'req_message';

    /**
     * Ссылка на сообщение
     * @var string
     */
    public string $url;

    /**
     * Установка сообщения
     * @param string $message
     * @return void
     */
    public function setMessage(string $message): void
    {
        $this->setField(static::MESSAGE_FIELD, $message);
    }

    /**
     * Отправка сообщения
     *
     * @throws MybbCurlException
     */
    public function submit(): MybbResponse
    {
        foreach (['submit', 'form_user', 'req_message'] as $key) {
            $this->fields[$key] = MybbEncoder::toForumEncoding($this->fields[$key] );
        }

        return parent::submit();
    }
}