<?php

namespace Kozhilya\MybbConnection\Exceptions;

use Exception;
use Kozhilya\MybbConnection\MybbLoader;
use Kozhilya\MybbConnection\MybbUser;

/**
 * Попытка входа в систему не успешна
 */
class MybbLoginFailedException extends Exception
{
    private readonly MybbUser $user;

    public function __construct(private readonly MybbLoader $loader, string $message)
    {
        $this->user = $loader->user;

        parent::__construct(sprintf("Попытка входа в систему как \"%s\" не успешна. Ответ форума: \"%s\".",
            $this->user->getLogin(),
            $message
        ));
    }

    /**
     * @return MybbUser
     */
    public function getUser(): MybbUser
    {
        return $this->user;
    }

    /**
     * @return MybbLoader
     */
    public function getLoader(): MybbLoader
    {
        return $this->loader;
    }
}